import matplotlib.pyplot as plt
import numpy as np
from mpl_toolkits.mplot3d import Axes3D
import subfunctions as sf
from scipy.optimize import root_scalar

rover = {'wheel_assembly': {'wheel': {'radius': 0.3, 'mass': 1},
                            'speed_reducer': {'type': 'reverted', 'diam_pinion': 0.05, 'diam_gear': 0.08, 'mass': 1.50},
                            'motor': {'torque_stall': 175, 'torque_noload': 0, 'speed_noload': 3.9, 'mass': 5}},
         'chassis': {'mass': 659}, 'science_payload': {'mass': 75}, 'power_subsys': {'mass': 90}}
planet = {'g': 3.72}

crr_array = np.linspace(0.01,0.5, 25)
slope_array_deg = np.linspace(-15, 45, 25)
crr, slope = np.meshgrid(crr_array, slope_array_deg)
vmax = np.zeros(np.shape(crr), dtype = float)
shape = np.shape(crr)[0]
lb = 0
ub = 3.9
for i in range(shape):
    for j in range(shape):
        crr_sample = float(crr[i][j])
        angle_sample = float(slope[i,j])
        fx = lambda x: sf.F_net(x, angle_sample, rover, planet, crr_sample)
        if fx(lb) * fx(ub) < 0:
            ans = root_scalar(fx, method='secant', x0=0, x1=3.9, rtol=0.00001, maxiter=1000)
            w_max = ans.root
            r = rover['wheel_assembly']['wheel']['radius']
            vmax[i, j] = r * w_max
        else:
            vmax[i,j] = np.nan

figure = plt.figure()
ax = Axes3D(figure, elev = 20, azim = 50)
ax.plot_surface(crr, slope, vmax)
plt.xlabel('Rolling Coefficient')
plt.ylabel('Terrain Slope')
plt.title('Combined Analysis')
ax.set_zlabel('Maximum velocity (m/s)')
plt.show()

